package zio.aws.iotthingsgraph.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{MaxResults, NextToken, Urn}
import scala.jdk.CollectionConverters.*
final case class GetSystemTemplateRevisionsRequest(
    id: Urn,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest = {
    import GetSystemTemplateRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
      .wrap(buildAwsValue())
}
object GetSystemTemplateRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsRequest =
      zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsRequest(
        id,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def id: Urn
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
  ) extends zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
  ): zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
