package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSystemInstanceResponse(
    summary: Option[zio.aws.iotthingsgraph.model.SystemInstanceSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse = {
    import CreateSystemInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse
      .wrap(buildAwsValue())
}
object CreateSystemInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse =
      zio.aws.iotthingsgraph.model
        .CreateSystemInstanceResponse(summary.map(value => value.asEditable))
    def summary
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse
  ) extends zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly {
    override val summary
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly] =
      scala
        .Option(impl.summary())
        .map(value =>
          zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse
  ): zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
