package zio.aws.iotthingsgraph
import zio.aws.iotthingsgraph.model.CreateSystemTemplateResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iotthingsgraph.{
  IoTThingsGraphAsyncClientBuilder,
  IoTThingsGraphAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.iotthingsgraph.model.{
  DescribeNamespaceRequest,
  SearchThingsRequest,
  DeleteSystemTemplateRequest,
  GetFlowTemplateRequest,
  CreateFlowTemplateRequest,
  GetFlowTemplateRevisionsRequest,
  DeprecateSystemTemplateRequest,
  DeleteFlowTemplateRequest,
  ListTagsForResourceRequest,
  DeleteNamespaceRequest,
  CreateSystemInstanceRequest,
  UploadEntityDefinitionsRequest,
  SearchFlowExecutionsRequest,
  UndeploySystemInstanceRequest,
  GetSystemTemplateRequest,
  GetSystemInstanceRequest,
  DeleteSystemInstanceRequest,
  GetNamespaceDeletionStatusRequest,
  ListFlowExecutionMessagesRequest,
  SearchSystemTemplatesRequest,
  DeploySystemInstanceRequest,
  GetUploadStatusRequest,
  SearchEntitiesRequest,
  GetEntitiesRequest,
  SearchSystemInstancesRequest,
  CreateSystemTemplateRequest,
  UntagResourceRequest,
  GetSystemTemplateRevisionsRequest,
  AssociateEntityToThingRequest,
  DissociateEntityFromThingRequest,
  UpdateFlowTemplateRequest,
  UpdateSystemTemplateRequest,
  SearchFlowTemplatesRequest,
  DeprecateFlowTemplateRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.iotthingsgraph.model.{
  GetEntitiesResponse,
  GetSystemTemplateRevisionsResponse,
  DescribeNamespaceResponse,
  AssociateEntityToThingResponse,
  GetSystemInstanceResponse,
  GetSystemTemplateResponse,
  UploadEntityDefinitionsResponse,
  SearchEntitiesResponse,
  SystemTemplateSummary,
  Tag,
  GetUploadStatusResponse,
  SearchSystemTemplatesResponse,
  UpdateSystemTemplateResponse,
  DissociateEntityFromThingResponse,
  ListTagsForResourceResponse,
  FlowTemplateSummary,
  UntagResourceResponse,
  CreateSystemInstanceResponse,
  UndeploySystemInstanceResponse,
  DeleteSystemTemplateResponse,
  CreateFlowTemplateResponse,
  UpdateFlowTemplateResponse,
  FlowExecutionMessage,
  SearchThingsResponse,
  CreateSystemTemplateResponse,
  DeleteFlowTemplateResponse,
  DeprecateFlowTemplateResponse,
  SearchFlowTemplatesResponse,
  DeleteNamespaceResponse,
  DeprecateSystemTemplateResponse,
  SearchSystemInstancesResponse,
  EntityDescription,
  GetFlowTemplateResponse,
  GetFlowTemplateRevisionsResponse,
  SystemInstanceSummary,
  DeploySystemInstanceResponse,
  DeleteSystemInstanceResponse,
  TagResourceResponse,
  SearchFlowExecutionsResponse,
  FlowExecutionSummary,
  ListFlowExecutionMessagesResponse,
  GetNamespaceDeletionStatusResponse,
  Thing
}
import software.amazon.awssdk.services.iotthingsgraph.paginators.{
  SearchFlowExecutionsPublisher,
  SearchFlowTemplatesPublisher,
  SearchSystemTemplatesPublisher,
  SearchEntitiesPublisher,
  SearchThingsPublisher,
  GetFlowTemplateRevisionsPublisher,
  ListTagsForResourcePublisher,
  SearchSystemInstancesPublisher,
  ListFlowExecutionMessagesPublisher,
  GetSystemTemplateRevisionsPublisher
}
import scala.jdk.CollectionConverters.*
trait IoTThingsGraph extends AspectSupport[IoTThingsGraph] {
  val api: IoTThingsGraphAsyncClient
  def getSystemInstance(request: GetSystemInstanceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly
  ]
  def deprecateSystemTemplate(request: DeprecateSystemTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DeprecateSystemTemplateResponse.ReadOnly
  ]
  def getEntities(
      request: GetEntitiesRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly]
  def dissociateEntityFromThing(request: DissociateEntityFromThingRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DissociateEntityFromThingResponse.ReadOnly
  ]
  def deploySystemInstance(request: DeploySystemInstanceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly
  ]
  def getSystemTemplate(request: GetSystemTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly
  ]
  def describeNamespace(request: DescribeNamespaceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly
  ]
  def undeploySystemInstance(request: UndeploySystemInstanceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly
  ]
  def searchFlowTemplates(request: SearchFlowTemplatesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
  ]
  def searchFlowTemplatesPaginated(request: SearchFlowTemplatesRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.SearchFlowTemplatesResponse.ReadOnly
  ]
  def createSystemInstance(request: CreateSystemInstanceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly
  ]
  def searchThings(
      request: SearchThingsRequest
  ): ZStream[Any, AwsError, zio.aws.iotthingsgraph.model.Thing.ReadOnly]
  def searchThingsPaginated(
      request: SearchThingsRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly]
  def associateEntityToThing(request: AssociateEntityToThingRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.AssociateEntityToThingResponse.ReadOnly
  ]
  def getFlowTemplate(
      request: GetFlowTemplateRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly]
  def deleteSystemInstance(request: DeleteSystemInstanceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteSystemInstanceResponse.ReadOnly
  ]
  def searchEntities(request: SearchEntitiesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
  ]
  def searchEntitiesPaginated(
      request: SearchEntitiesRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.UntagResourceResponse.ReadOnly]
  def createFlowTemplate(request: CreateFlowTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly
  ]
  def deleteSystemTemplate(request: DeleteSystemTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteSystemTemplateResponse.ReadOnly
  ]
  def deprecateFlowTemplate(request: DeprecateFlowTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DeprecateFlowTemplateResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.iotthingsgraph.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.TagResourceResponse.ReadOnly]
  def getNamespaceDeletionStatus(
      request: GetNamespaceDeletionStatusRequest
  ): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly
  ]
  def createSystemTemplate(
      request: CreateSystemTemplateRequest
  ): IO[AwsError, ReadOnly]
  def uploadEntityDefinitions(request: UploadEntityDefinitionsRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.UploadEntityDefinitionsResponse.ReadOnly
  ]
  def searchFlowExecutions(request: SearchFlowExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly
  ]
  def searchFlowExecutionsPaginated(request: SearchFlowExecutionsRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly
  ]
  def listFlowExecutionMessages(
      request: ListFlowExecutionMessagesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly
  ]
  def listFlowExecutionMessagesPaginated(
      request: ListFlowExecutionMessagesRequest
  ): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly
  ]
  def getUploadStatus(
      request: GetUploadStatusRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly]
  def getSystemTemplateRevisions(
      request: GetSystemTemplateRevisionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
  ]
  def getSystemTemplateRevisionsPaginated(
      request: GetSystemTemplateRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly
  ]
  def getFlowTemplateRevisions(
      request: GetFlowTemplateRevisionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
  ]
  def getFlowTemplateRevisionsPaginated(
      request: GetFlowTemplateRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly
  ]
  def deleteNamespace(
      request: DeleteNamespaceRequest
  ): IO[AwsError, zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly]
  def searchSystemTemplates(request: SearchSystemTemplatesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
  ]
  def searchSystemTemplatesPaginated(request: SearchSystemTemplatesRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.SearchSystemTemplatesResponse.ReadOnly
  ]
  def updateSystemTemplate(request: UpdateSystemTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly
  ]
  def deleteFlowTemplate(request: DeleteFlowTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteFlowTemplateResponse.ReadOnly
  ]
  def searchSystemInstances(request: SearchSystemInstancesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
  ]
  def searchSystemInstancesPaginated(request: SearchSystemInstancesRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly
  ]
  def updateFlowTemplate(request: UpdateFlowTemplateRequest): IO[
    AwsError,
    zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly
  ]
}
object IoTThingsGraph {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTThingsGraph] = customized(
    identity
  )
  def customized(
      customization: IoTThingsGraphAsyncClientBuilder => IoTThingsGraphAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTThingsGraph] = managed(
    customization
  ).toLayer
  def managed(
      customization: IoTThingsGraphAsyncClientBuilder => IoTThingsGraphAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, IoTThingsGraph] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = IoTThingsGraphAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTThingsGraphAsyncClient, IoTThingsGraphAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        IoTThingsGraphAsyncClient,
        IoTThingsGraphAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new IoTThingsGraphImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTThingsGraphImpl[R](
      override val api: IoTThingsGraphAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTThingsGraph
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTThingsGraph"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTThingsGraphImpl[R1] = new IoTThingsGraphImpl(api, newAspect, r)
    def getSystemInstance(request: GetSystemInstanceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest,
      GetSystemInstanceResponse
    ]("getSystemInstance", api.getSystemInstance)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.wrap)
      .provideEnvironment(r)
    def deprecateSystemTemplate(request: DeprecateSystemTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeprecateSystemTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest,
      DeprecateSystemTemplateResponse
    ]("deprecateSystemTemplate", api.deprecateSystemTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.DeprecateSystemTemplateResponse.wrap)
      .provideEnvironment(r)
    def getEntities(
        request: GetEntitiesRequest
    ): IO[AwsError, zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest,
        GetEntitiesResponse
      ]("getEntities", api.getEntities)(request.buildAwsValue())
        .map(zio.aws.iotthingsgraph.model.GetEntitiesResponse.wrap)
        .provideEnvironment(r)
    def dissociateEntityFromThing(
        request: DissociateEntityFromThingRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DissociateEntityFromThingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest,
      DissociateEntityFromThingResponse
    ]("dissociateEntityFromThing", api.dissociateEntityFromThing)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.DissociateEntityFromThingResponse.wrap)
      .provideEnvironment(r)
    def deploySystemInstance(request: DeploySystemInstanceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest,
      DeploySystemInstanceResponse
    ]("deploySystemInstance", api.deploySystemInstance)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.wrap)
      .provideEnvironment(r)
    def getSystemTemplate(request: GetSystemTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest,
      GetSystemTemplateResponse
    ]("getSystemTemplate", api.getSystemTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.wrap)
      .provideEnvironment(r)
    def describeNamespace(request: DescribeNamespaceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest,
      DescribeNamespaceResponse
    ]("describeNamespace", api.describeNamespace)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.wrap)
      .provideEnvironment(r)
    def undeploySystemInstance(request: UndeploySystemInstanceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest,
      UndeploySystemInstanceResponse
    ]("undeploySystemInstance", api.undeploySystemInstance)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.wrap)
      .provideEnvironment(r)
    def searchFlowTemplates(request: SearchFlowTemplatesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest,
      FlowTemplateSummary,
      SearchFlowTemplatesPublisher
    ]("searchFlowTemplates", api.searchFlowTemplatesPaginator, _.summaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(item))
      .provideEnvironment(r)
    def searchFlowTemplatesPaginated(request: SearchFlowTemplatesRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.SearchFlowTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest,
      SearchFlowTemplatesResponse
    ]("searchFlowTemplates", api.searchFlowTemplates)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.SearchFlowTemplatesResponse.wrap)
      .provideEnvironment(r)
    def createSystemInstance(request: CreateSystemInstanceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest,
      CreateSystemInstanceResponse
    ]("createSystemInstance", api.createSystemInstance)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.wrap)
      .provideEnvironment(r)
    def searchThings(request: SearchThingsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.Thing.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest,
      Thing,
      SearchThingsPublisher
    ]("searchThings", api.searchThingsPaginator, _.things())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotthingsgraph.model.Thing.wrap(item))
      .provideEnvironment(r)
    def searchThingsPaginated(request: SearchThingsRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest,
      SearchThingsResponse
    ]("searchThings", api.searchThings)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.SearchThingsResponse.wrap)
      .provideEnvironment(r)
    def associateEntityToThing(request: AssociateEntityToThingRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.AssociateEntityToThingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest,
      AssociateEntityToThingResponse
    ]("associateEntityToThing", api.associateEntityToThing)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.AssociateEntityToThingResponse.wrap)
      .provideEnvironment(r)
    def getFlowTemplate(request: GetFlowTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest,
      GetFlowTemplateResponse
    ]("getFlowTemplate", api.getFlowTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.wrap)
      .provideEnvironment(r)
    def deleteSystemInstance(request: DeleteSystemInstanceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeleteSystemInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest,
      DeleteSystemInstanceResponse
    ]("deleteSystemInstance", api.deleteSystemInstance)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.DeleteSystemInstanceResponse.wrap)
      .provideEnvironment(r)
    def searchEntities(request: SearchEntitiesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest,
      EntityDescription,
      SearchEntitiesPublisher
    ]("searchEntities", api.searchEntitiesPaginator, _.descriptions())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotthingsgraph.model.EntityDescription.wrap(item))
      .provideEnvironment(r)
    def searchEntitiesPaginated(request: SearchEntitiesRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest,
      SearchEntitiesResponse
    ]("searchEntities", api.searchEntities)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.SearchEntitiesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def createFlowTemplate(request: CreateFlowTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest,
      CreateFlowTemplateResponse
    ]("createFlowTemplate", api.createFlowTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.wrap)
      .provideEnvironment(r)
    def deleteSystemTemplate(request: DeleteSystemTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeleteSystemTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest,
      DeleteSystemTemplateResponse
    ]("deleteSystemTemplate", api.deleteSystemTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.DeleteSystemTemplateResponse.wrap)
      .provideEnvironment(r)
    def deprecateFlowTemplate(request: DeprecateFlowTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeprecateFlowTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest,
      DeprecateFlowTemplateResponse
    ]("deprecateFlowTemplate", api.deprecateFlowTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.DeprecateFlowTemplateResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.iotthingsgraph.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest,
        Tag,
        ListTagsForResourcePublisher
      ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iotthingsgraph.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.iotthingsgraph.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.iotthingsgraph.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getNamespaceDeletionStatus(
        request: GetNamespaceDeletionStatusRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest,
      GetNamespaceDeletionStatusResponse
    ]("getNamespaceDeletionStatus", api.getNamespaceDeletionStatus)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.wrap)
      .provideEnvironment(r)
    def createSystemTemplate(
        request: CreateSystemTemplateRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest,
      CreateSystemTemplateResponse
    ]("createSystemTemplate", api.createSystemTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.CreateSystemTemplateResponse.wrap)
      .provideEnvironment(r)
    def uploadEntityDefinitions(request: UploadEntityDefinitionsRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.UploadEntityDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest,
      UploadEntityDefinitionsResponse
    ]("uploadEntityDefinitions", api.uploadEntityDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.UploadEntityDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def searchFlowExecutions(request: SearchFlowExecutionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest,
      FlowExecutionSummary,
      SearchFlowExecutionsPublisher
    ]("searchFlowExecutions", api.searchFlowExecutionsPaginator, _.summaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotthingsgraph.model.FlowExecutionSummary.wrap(item))
      .provideEnvironment(r)
    def searchFlowExecutionsPaginated(request: SearchFlowExecutionsRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest,
      SearchFlowExecutionsResponse
    ]("searchFlowExecutions", api.searchFlowExecutions)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def listFlowExecutionMessages(
        request: ListFlowExecutionMessagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest,
      FlowExecutionMessage,
      ListFlowExecutionMessagesPublisher
    ](
      "listFlowExecutionMessages",
      api.listFlowExecutionMessagesPaginator,
      _.messages()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotthingsgraph.model.FlowExecutionMessage.wrap(item))
      .provideEnvironment(r)
    def listFlowExecutionMessagesPaginated(
        request: ListFlowExecutionMessagesRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest,
      ListFlowExecutionMessagesResponse
    ]("listFlowExecutionMessages", api.listFlowExecutionMessages)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.wrap)
      .provideEnvironment(r)
    def getUploadStatus(request: GetUploadStatusRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest,
      GetUploadStatusResponse
    ]("getUploadStatus", api.getUploadStatus)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.GetUploadStatusResponse.wrap)
      .provideEnvironment(r)
    def getSystemTemplateRevisions(
        request: GetSystemTemplateRevisionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest,
      SystemTemplateSummary,
      GetSystemTemplateRevisionsPublisher
    ](
      "getSystemTemplateRevisions",
      api.getSystemTemplateRevisionsPaginator,
      _.summaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotthingsgraph.model.SystemTemplateSummary.wrap(item)
      )
      .provideEnvironment(r)
    def getSystemTemplateRevisionsPaginated(
        request: GetSystemTemplateRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest,
      GetSystemTemplateRevisionsResponse
    ]("getSystemTemplateRevisions", api.getSystemTemplateRevisions)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.wrap)
      .provideEnvironment(r)
    def getFlowTemplateRevisions(
        request: GetFlowTemplateRevisionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest,
      FlowTemplateSummary,
      GetFlowTemplateRevisionsPublisher
    ](
      "getFlowTemplateRevisions",
      api.getFlowTemplateRevisionsPaginator,
      _.summaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(item))
      .provideEnvironment(r)
    def getFlowTemplateRevisionsPaginated(
        request: GetFlowTemplateRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest,
      GetFlowTemplateRevisionsResponse
    ]("getFlowTemplateRevisions", api.getFlowTemplateRevisions)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.wrap)
      .provideEnvironment(r)
    def deleteNamespace(request: DeleteNamespaceRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest,
      DeleteNamespaceResponse
    ]("deleteNamespace", api.deleteNamespace)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.wrap)
      .provideEnvironment(r)
    def searchSystemTemplates(request: SearchSystemTemplatesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest,
      SystemTemplateSummary,
      SearchSystemTemplatesPublisher
    ](
      "searchSystemTemplates",
      api.searchSystemTemplatesPaginator,
      _.summaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotthingsgraph.model.SystemTemplateSummary.wrap(item)
      )
      .provideEnvironment(r)
    def searchSystemTemplatesPaginated(
        request: SearchSystemTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.SearchSystemTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest,
      SearchSystemTemplatesResponse
    ]("searchSystemTemplates", api.searchSystemTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.SearchSystemTemplatesResponse.wrap)
      .provideEnvironment(r)
    def updateSystemTemplate(request: UpdateSystemTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest,
      UpdateSystemTemplateResponse
    ]("updateSystemTemplate", api.updateSystemTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.wrap)
      .provideEnvironment(r)
    def deleteFlowTemplate(request: DeleteFlowTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.DeleteFlowTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest,
      DeleteFlowTemplateResponse
    ]("deleteFlowTemplate", api.deleteFlowTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.DeleteFlowTemplateResponse.wrap)
      .provideEnvironment(r)
    def searchSystemInstances(request: SearchSystemInstancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest,
      SystemInstanceSummary,
      SearchSystemInstancesPublisher
    ](
      "searchSystemInstances",
      api.searchSystemInstancesPaginator,
      _.summaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def searchSystemInstancesPaginated(
        request: SearchSystemInstancesRequest
    ): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest,
      SearchSystemInstancesResponse
    ]("searchSystemInstances", api.searchSystemInstances)(
      request.buildAwsValue()
    ).map(zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.wrap)
      .provideEnvironment(r)
    def updateFlowTemplate(request: UpdateFlowTemplateRequest): IO[
      AwsError,
      zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest,
      UpdateFlowTemplateResponse
    ]("updateFlowTemplate", api.updateFlowTemplate)(request.buildAwsValue())
      .map(zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.wrap)
      .provideEnvironment(r)
  }
  def getSystemInstance(request: GetSystemInstanceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSystemInstance(request))
  def deprecateSystemTemplate(request: DeprecateSystemTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeprecateSystemTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprecateSystemTemplate(request))
  def getEntities(request: GetEntitiesRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEntities(request))
  def dissociateEntityFromThing(request: DissociateEntityFromThingRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DissociateEntityFromThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.dissociateEntityFromThing(request))
  def deploySystemInstance(request: DeploySystemInstanceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deploySystemInstance(request))
  def getSystemTemplate(request: GetSystemTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSystemTemplate(request))
  def describeNamespace(request: DescribeNamespaceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNamespace(request))
  def undeploySystemInstance(request: UndeploySystemInstanceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.undeploySystemInstance(request))
  def searchFlowTemplates(request: SearchFlowTemplatesRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchFlowTemplates(request))
  def searchFlowTemplatesPaginated(request: SearchFlowTemplatesRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SearchFlowTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchFlowTemplatesPaginated(request))
  def createSystemInstance(request: CreateSystemInstanceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSystemInstance(request))
  def searchThings(request: SearchThingsRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.Thing.ReadOnly
  ] = ZStream.serviceWithStream(_.searchThings(request))
  def searchThingsPaginated(request: SearchThingsRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchThingsPaginated(request))
  def associateEntityToThing(request: AssociateEntityToThingRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.AssociateEntityToThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateEntityToThing(request))
  def getFlowTemplate(request: GetFlowTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFlowTemplate(request))
  def deleteSystemInstance(request: DeleteSystemInstanceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteSystemInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSystemInstance(request))
  def searchEntities(request: SearchEntitiesRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.searchEntities(request))
  def searchEntitiesPaginated(request: SearchEntitiesRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchEntitiesPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createFlowTemplate(request: CreateFlowTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFlowTemplate(request))
  def deleteSystemTemplate(request: DeleteSystemTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteSystemTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSystemTemplate(request))
  def deprecateFlowTemplate(request: DeprecateFlowTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeprecateFlowTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprecateFlowTemplate(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getNamespaceDeletionStatus(
      request: GetNamespaceDeletionStatusRequest
  ): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNamespaceDeletionStatus(request))
  def createSystemTemplate(
      request: CreateSystemTemplateRequest
  ): ZIO[zio.aws.iotthingsgraph.IoTThingsGraph, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createSystemTemplate(request))
  def uploadEntityDefinitions(request: UploadEntityDefinitionsRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.UploadEntityDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadEntityDefinitions(request))
  def searchFlowExecutions(request: SearchFlowExecutionsRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchFlowExecutions(request))
  def searchFlowExecutionsPaginated(request: SearchFlowExecutionsRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchFlowExecutionsPaginated(request))
  def listFlowExecutionMessages(
      request: ListFlowExecutionMessagesRequest
  ): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly
  ] = ZStream.serviceWithStream(_.listFlowExecutionMessages(request))
  def listFlowExecutionMessagesPaginated(
      request: ListFlowExecutionMessagesRequest
  ): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFlowExecutionMessagesPaginated(request))
  def getUploadStatus(request: GetUploadStatusRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUploadStatus(request))
  def getSystemTemplateRevisions(
      request: GetSystemTemplateRevisionsRequest
  ): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getSystemTemplateRevisions(request))
  def getSystemTemplateRevisionsPaginated(
      request: GetSystemTemplateRevisionsRequest
  ): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSystemTemplateRevisionsPaginated(request))
  def getFlowTemplateRevisions(
      request: GetFlowTemplateRevisionsRequest
  ): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getFlowTemplateRevisions(request))
  def getFlowTemplateRevisionsPaginated(
      request: GetFlowTemplateRevisionsRequest
  ): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFlowTemplateRevisionsPaginated(request))
  def deleteNamespace(request: DeleteNamespaceRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNamespace(request))
  def searchSystemTemplates(request: SearchSystemTemplatesRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchSystemTemplates(request))
  def searchSystemTemplatesPaginated(
      request: SearchSystemTemplatesRequest
  ): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SearchSystemTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSystemTemplatesPaginated(request))
  def updateSystemTemplate(request: UpdateSystemTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSystemTemplate(request))
  def deleteFlowTemplate(request: DeleteFlowTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.DeleteFlowTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFlowTemplate(request))
  def searchSystemInstances(request: SearchSystemInstancesRequest): ZStream[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchSystemInstances(request))
  def searchSystemInstancesPaginated(
      request: SearchSystemInstancesRequest
  ): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSystemInstancesPaginated(request))
  def updateFlowTemplate(request: UpdateFlowTemplateRequest): ZIO[
    zio.aws.iotthingsgraph.IoTThingsGraph,
    AwsError,
    zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFlowTemplate(request))
}
