package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetSystemTemplateRevisionsResponse(
    summaries: Option[
      Iterable[zio.aws.iotthingsgraph.model.SystemTemplateSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse = {
    import GetSystemTemplateRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
      .wrap(buildAwsValue())
}
object GetSystemTemplateRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse =
      zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Option[
      List[zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
  ) extends zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly {
    override val summaries: Option[
      List[zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly]
    ] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.SystemTemplateSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
  ): zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
