package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.SystemTemplateFilterValue
import scala.jdk.CollectionConverters.*
final case class SystemTemplateFilter(
    name: zio.aws.iotthingsgraph.model.SystemTemplateFilterName,
    value: Iterable[SystemTemplateFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateFilter = {
    import SystemTemplateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateFilter
      .builder()
      .name(name.unwrap)
      .value(value.map { item =>
        SystemTemplateFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SystemTemplateFilter.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemTemplateFilter.wrap(buildAwsValue())
}
object SystemTemplateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemTemplateFilter =
      zio.aws.iotthingsgraph.model.SystemTemplateFilter(name, value)
    def name: zio.aws.iotthingsgraph.model.SystemTemplateFilterName
    def value: List[SystemTemplateFilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.SystemTemplateFilterName
    ] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, List[SystemTemplateFilterValue]] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateFilter
  ) extends zio.aws.iotthingsgraph.model.SystemTemplateFilter.ReadOnly {
    override val name: zio.aws.iotthingsgraph.model.SystemTemplateFilterName =
      zio.aws.iotthingsgraph.model.SystemTemplateFilterName.wrap(impl.name())
    override val value: List[SystemTemplateFilterValue] = impl
      .value()
      .asScala
      .map { item =>
        zio.aws.iotthingsgraph.model.primitives.SystemTemplateFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateFilter
  ): zio.aws.iotthingsgraph.model.SystemTemplateFilter.ReadOnly = new Wrapper(
    impl
  )
}
