package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Timestamp, Version, Arn, Urn}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SystemTemplateSummary(
    id: Option[Urn] = None,
    arn: Option[Arn] = None,
    revisionNumber: Option[Version] = None,
    createdAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary = {
    import SystemTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        revisionNumber.map(value => Version.unwrap(value): java.lang.Long)
      )(_.revisionNumber)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemTemplateSummary.wrap(buildAwsValue())
}
object SystemTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemTemplateSummary =
      zio.aws.iotthingsgraph.model.SystemTemplateSummary(
        id.map(value => value),
        arn.map(value => value),
        revisionNumber.map(value => value),
        createdAt.map(value => value)
      )
    def id: Option[Urn]
    def arn: Option[Arn]
    def revisionNumber: Option[Version]
    def createdAt: Option[Timestamp]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getRevisionNumber: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("revisionNumber", revisionNumber)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary
  ) extends zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly {
    override val id: Option[Urn] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val revisionNumber: Option[Version] = scala
      .Option(impl.revisionNumber())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary
  ): zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly = new Wrapper(
    impl
  )
}
