package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn}
import scala.jdk.CollectionConverters.*
final case class GetEntitiesRequest(
    ids: Iterable[Urn],
    namespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest = {
    import GetEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest
      .builder()
      .ids(ids.map { item =>
        Urn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.GetEntitiesRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetEntitiesRequest.wrap(buildAwsValue())
}
object GetEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetEntitiesRequest =
      zio.aws.iotthingsgraph.model
        .GetEntitiesRequest(ids, namespaceVersion.map(value => value))
    def ids: List[Urn]
    def namespaceVersion: Option[Version]
    def getIds: ZIO[Any, Nothing, List[Urn]] = ZIO.succeed(ids)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest
  ) extends zio.aws.iotthingsgraph.model.GetEntitiesRequest.ReadOnly {
    override val ids: List[Urn] = impl
      .ids()
      .asScala
      .map { item =>
        zio.aws.iotthingsgraph.model.primitives.Urn(item)
      }
      .toList
    override val namespaceVersion: Option[Version] = scala
      .Option(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest
  ): zio.aws.iotthingsgraph.model.GetEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
