package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{RoleArn, Enabled}
import scala.jdk.CollectionConverters.*
final case class MetricsConfiguration(
    cloudMetricEnabled: Option[Enabled] = None,
    metricRuleRoleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration = {
    import MetricsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration
      .builder()
      .optionallyWith(
        cloudMetricEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.cloudMetricEnabled)
      .optionallyWith(
        metricRuleRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.metricRuleRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly =
    zio.aws.iotthingsgraph.model.MetricsConfiguration.wrap(buildAwsValue())
}
object MetricsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.MetricsConfiguration =
      zio.aws.iotthingsgraph.model.MetricsConfiguration(
        cloudMetricEnabled.map(value => value),
        metricRuleRoleArn.map(value => value)
      )
    def cloudMetricEnabled: Option[Enabled]
    def metricRuleRoleArn: Option[RoleArn]
    def getCloudMetricEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("cloudMetricEnabled", cloudMetricEnabled)
    def getMetricRuleRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("metricRuleRoleArn", metricRuleRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration
  ) extends zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly {
    override val cloudMetricEnabled: Option[Enabled] = scala
      .Option(impl.cloudMetricEnabled())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Enabled(value))
    override val metricRuleRoleArn: Option[RoleArn] = scala
      .Option(impl.metricRuleRoleArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration
  ): zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
