package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.FlowTemplateFilterValue
import scala.jdk.CollectionConverters.*
final case class FlowTemplateFilter(
    name: zio.aws.iotthingsgraph.model.FlowTemplateFilterName,
    value: Iterable[FlowTemplateFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateFilter = {
    import FlowTemplateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateFilter
      .builder()
      .name(name.unwrap)
      .value(value.map { item =>
        FlowTemplateFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.FlowTemplateFilter.ReadOnly =
    zio.aws.iotthingsgraph.model.FlowTemplateFilter.wrap(buildAwsValue())
}
object FlowTemplateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.FlowTemplateFilter =
      zio.aws.iotthingsgraph.model.FlowTemplateFilter(name, value)
    def name: zio.aws.iotthingsgraph.model.FlowTemplateFilterName
    def value: List[FlowTemplateFilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.FlowTemplateFilterName
    ] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, List[FlowTemplateFilterValue]] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateFilter
  ) extends zio.aws.iotthingsgraph.model.FlowTemplateFilter.ReadOnly {
    override val name: zio.aws.iotthingsgraph.model.FlowTemplateFilterName =
      zio.aws.iotthingsgraph.model.FlowTemplateFilterName.wrap(impl.name())
    override val value: List[FlowTemplateFilterValue] = impl
      .value()
      .asScala
      .map { item =>
        zio.aws.iotthingsgraph.model.primitives.FlowTemplateFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateFilter
  ): zio.aws.iotthingsgraph.model.FlowTemplateFilter.ReadOnly = new Wrapper(
    impl
  )
}
