package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.ThingName
import scala.jdk.CollectionConverters.*
final case class DissociateEntityFromThingRequest(
    thingName: ThingName,
    entityType: zio.aws.iotthingsgraph.model.EntityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest = {
    import DissociateEntityFromThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .entityType(entityType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DissociateEntityFromThingRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.DissociateEntityFromThingRequest
      .wrap(buildAwsValue())
}
object DissociateEntityFromThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.DissociateEntityFromThingRequest =
      zio.aws.iotthingsgraph.model
        .DissociateEntityFromThingRequest(thingName, entityType)
    def thingName: ThingName
    def entityType: zio.aws.iotthingsgraph.model.EntityType
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getEntityType
        : ZIO[Any, Nothing, zio.aws.iotthingsgraph.model.EntityType] =
      ZIO.succeed(entityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest
  ) extends zio.aws.iotthingsgraph.model.DissociateEntityFromThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iotthingsgraph.model.primitives.ThingName(impl.thingName())
    override val entityType: zio.aws.iotthingsgraph.model.EntityType =
      zio.aws.iotthingsgraph.model.EntityType.wrap(impl.entityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest
  ): zio.aws.iotthingsgraph.model.DissociateEntityFromThingRequest.ReadOnly =
    new Wrapper(impl)
}
