package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFlowTemplateResponse(
    summary: Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse = {
    import UpdateFlowTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse
      .wrap(buildAwsValue())
}
object UpdateFlowTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse =
      zio.aws.iotthingsgraph.model
        .UpdateFlowTemplateResponse(summary.map(value => value.asEditable))
    def summary
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse
  ) extends zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly {
    override val summary
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly] =
      scala
        .Option(impl.summary())
        .map(value =>
          zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse
  ): zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
