package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Urn
import scala.jdk.CollectionConverters.*
final case class UndeploySystemInstanceRequest(id: Option[Urn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest = {
    import UndeploySystemInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UndeploySystemInstanceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.UndeploySystemInstanceRequest
      .wrap(buildAwsValue())
}
object UndeploySystemInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.UndeploySystemInstanceRequest =
      zio.aws.iotthingsgraph.model
        .UndeploySystemInstanceRequest(id.map(value => value))
    def id: Option[Urn]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest
  ) extends zio.aws.iotthingsgraph.model.UndeploySystemInstanceRequest.ReadOnly {
    override val id: Option[Urn] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest
  ): zio.aws.iotthingsgraph.model.UndeploySystemInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
