package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, NamespaceName, Arn}
import scala.jdk.CollectionConverters.*
final case class DescribeNamespaceResponse(
    namespaceArn: Option[Arn] = None,
    namespaceName: Option[NamespaceName] = None,
    trackingNamespaceName: Option[NamespaceName] = None,
    trackingNamespaceVersion: Option[Version] = None,
    namespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse = {
    import DescribeNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
      .builder()
      .optionallyWith(
        namespaceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.namespaceArn)
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(
        trackingNamespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.trackingNamespaceName)
      .optionallyWith(
        trackingNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.trackingNamespaceVersion)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.wrap(buildAwsValue())
}
object DescribeNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DescribeNamespaceResponse =
      zio.aws.iotthingsgraph.model.DescribeNamespaceResponse(
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        trackingNamespaceName.map(value => value),
        trackingNamespaceVersion.map(value => value),
        namespaceVersion.map(value => value)
      )
    def namespaceArn: Option[Arn]
    def namespaceName: Option[NamespaceName]
    def trackingNamespaceName: Option[NamespaceName]
    def trackingNamespaceVersion: Option[Version]
    def namespaceVersion: Option[Version]
    def getNamespaceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getTrackingNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("trackingNamespaceName", trackingNamespaceName)
    def getTrackingNamespaceVersion: ZIO[Any, AwsError, Version] = AwsError
      .unwrapOptionField("trackingNamespaceVersion", trackingNamespaceVersion)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
  ) extends zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly {
    override val namespaceArn: Option[Arn] = scala
      .Option(impl.namespaceArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val namespaceName: Option[NamespaceName] = scala
      .Option(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
    override val trackingNamespaceName: Option[NamespaceName] = scala
      .Option(impl.trackingNamespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
    override val trackingNamespaceVersion: Option[Version] = scala
      .Option(impl.trackingNamespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
    override val namespaceVersion: Option[Version] = scala
      .Option(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
  ): zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
