package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters._
sealed trait DefinitionLanguage {
  def unwrap
      : software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage
}
object DefinitionLanguage {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage
  ): zio.aws.iotthingsgraph.model.DefinitionLanguage = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage.GRAPHQL =>
      val r = GRAPHQL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.DefinitionLanguage {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage =
      software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage.UNKNOWN_TO_SDK_VERSION
  }
  case object GRAPHQL extends zio.aws.iotthingsgraph.model.DefinitionLanguage {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage =
      software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage.GRAPHQL
  }
}
