package zio.aws.iotthingsgraph
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient
import zio.{ZEnvironment, URLayer}
import zio.mock.{Proxy, Mock}
object IoTThingsGraphMock extends Mock[IoTThingsGraph] {
  val compose: URLayer[Proxy, IoTThingsGraph] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IoTThingsGraph] { rts =>
        zio.ZIO.succeed {
          new IoTThingsGraph {
            val api: IoTThingsGraphAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IoTThingsGraph = this
          }
        }
      }
    }
  }
}
