package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters._
sealed trait SystemInstanceDeploymentStatus {
  def unwrap: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus
}
object SystemInstanceDeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus
  ): zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.NOT_DEPLOYED =>
      val r = NOT_DEPLOYED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.BOOTSTRAP =>
      val r = BOOTSTRAP
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.DEPLOY_IN_PROGRESS =>
      val r = DEPLOY_IN_PROGRESS
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.DEPLOYED_IN_TARGET =>
      val r = DEPLOYED_IN_TARGET
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.UNDEPLOY_IN_PROGRESS =>
      val r = UNDEPLOY_IN_PROGRESS
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.PENDING_DELETE =>
      val r = PENDING_DELETE
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.DELETED_IN_TARGET =>
      val r = DELETED_IN_TARGET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_DEPLOYED
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.NOT_DEPLOYED
  }
  case object BOOTSTRAP
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.BOOTSTRAP
  }
  case object DEPLOY_IN_PROGRESS
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.DEPLOY_IN_PROGRESS
  }
  case object DEPLOYED_IN_TARGET
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.DEPLOYED_IN_TARGET
  }
  case object UNDEPLOY_IN_PROGRESS
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.UNDEPLOY_IN_PROGRESS
  }
  case object FAILED
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.FAILED
  }
  case object PENDING_DELETE
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.PENDING_DELETE
  }
  case object DELETED_IN_TARGET
      extends zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus.DELETED_IN_TARGET
  }
}
