package zio.aws.iotthingsgraph
import zio.aws.iotthingsgraph.model.CreateSystemTemplateResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.iotthingsgraph.model.{
  DescribeNamespaceRequest,
  SearchThingsRequest,
  DeleteSystemTemplateRequest,
  GetFlowTemplateRequest,
  CreateFlowTemplateRequest,
  GetFlowTemplateRevisionsRequest,
  DeprecateSystemTemplateRequest,
  DeleteFlowTemplateRequest,
  ListTagsForResourceRequest,
  DeleteNamespaceRequest,
  CreateSystemInstanceRequest,
  UploadEntityDefinitionsRequest,
  SearchFlowExecutionsRequest,
  UndeploySystemInstanceRequest,
  GetSystemTemplateRequest,
  GetSystemInstanceRequest,
  DeleteSystemInstanceRequest,
  GetNamespaceDeletionStatusRequest,
  ListFlowExecutionMessagesRequest,
  SearchSystemTemplatesRequest,
  DeploySystemInstanceRequest,
  GetUploadStatusRequest,
  SearchEntitiesRequest,
  GetEntitiesRequest,
  SearchSystemInstancesRequest,
  CreateSystemTemplateRequest,
  UntagResourceRequest,
  GetSystemTemplateRevisionsRequest,
  AssociateEntityToThingRequest,
  DissociateEntityFromThingRequest,
  UpdateFlowTemplateRequest,
  UpdateSystemTemplateRequest,
  SearchFlowTemplatesRequest,
  DeprecateFlowTemplateRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object IoTThingsGraphMock extends Mock[IoTThingsGraph] {
  object GetSystemInstance
      extends Effect[
        GetSystemInstanceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly
      ]
  object DeprecateSystemTemplate
      extends Effect[
        DeprecateSystemTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeprecateSystemTemplateResponse.ReadOnly
      ]
  object GetEntities
      extends Effect[
        GetEntitiesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly
      ]
  object DissociateEntityFromThing
      extends Effect[
        DissociateEntityFromThingRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DissociateEntityFromThingResponse.ReadOnly
      ]
  object DeploySystemInstance
      extends Effect[
        DeploySystemInstanceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly
      ]
  object GetSystemTemplate
      extends Effect[
        GetSystemTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly
      ]
  object DescribeNamespace
      extends Effect[
        DescribeNamespaceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly
      ]
  object UndeploySystemInstance
      extends Effect[
        UndeploySystemInstanceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly
      ]
  object SearchFlowTemplates
      extends Stream[
        SearchFlowTemplatesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
      ]
  object SearchFlowTemplatesPaginated
      extends Effect[
        SearchFlowTemplatesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SearchFlowTemplatesResponse.ReadOnly
      ]
  object CreateSystemInstance
      extends Effect[
        CreateSystemInstanceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly
      ]
  object SearchThings
      extends Stream[
        SearchThingsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.Thing.ReadOnly
      ]
  object SearchThingsPaginated
      extends Effect[
        SearchThingsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly
      ]
  object AssociateEntityToThing
      extends Effect[
        AssociateEntityToThingRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.AssociateEntityToThingResponse.ReadOnly
      ]
  object GetFlowTemplate
      extends Effect[
        GetFlowTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly
      ]
  object DeleteSystemInstance
      extends Effect[
        DeleteSystemInstanceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeleteSystemInstanceResponse.ReadOnly
      ]
  object SearchEntities
      extends Stream[
        SearchEntitiesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
      ]
  object SearchEntitiesPaginated
      extends Effect[
        SearchEntitiesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.UntagResourceResponse.ReadOnly
      ]
  object CreateFlowTemplate
      extends Effect[
        CreateFlowTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly
      ]
  object DeleteSystemTemplate
      extends Effect[
        DeleteSystemTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeleteSystemTemplateResponse.ReadOnly
      ]
  object DeprecateFlowTemplate
      extends Effect[
        DeprecateFlowTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeprecateFlowTemplateResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.TagResourceResponse.ReadOnly
      ]
  object GetNamespaceDeletionStatus
      extends Effect[
        GetNamespaceDeletionStatusRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly
      ]
  object CreateSystemTemplate
      extends Effect[CreateSystemTemplateRequest, AwsError, ReadOnly]
  object UploadEntityDefinitions
      extends Effect[
        UploadEntityDefinitionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.UploadEntityDefinitionsResponse.ReadOnly
      ]
  object SearchFlowExecutions
      extends Stream[
        SearchFlowExecutionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly
      ]
  object SearchFlowExecutionsPaginated
      extends Effect[
        SearchFlowExecutionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly
      ]
  object ListFlowExecutionMessages
      extends Stream[
        ListFlowExecutionMessagesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly
      ]
  object ListFlowExecutionMessagesPaginated
      extends Effect[
        ListFlowExecutionMessagesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly
      ]
  object GetUploadStatus
      extends Effect[
        GetUploadStatusRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly
      ]
  object GetSystemTemplateRevisions
      extends Stream[
        GetSystemTemplateRevisionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
      ]
  object GetSystemTemplateRevisionsPaginated
      extends Effect[
        GetSystemTemplateRevisionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly
      ]
  object GetFlowTemplateRevisions
      extends Stream[
        GetFlowTemplateRevisionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
      ]
  object GetFlowTemplateRevisionsPaginated
      extends Effect[
        GetFlowTemplateRevisionsRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly
      ]
  object DeleteNamespace
      extends Effect[
        DeleteNamespaceRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly
      ]
  object SearchSystemTemplates
      extends Stream[
        SearchSystemTemplatesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
      ]
  object SearchSystemTemplatesPaginated
      extends Effect[
        SearchSystemTemplatesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SearchSystemTemplatesResponse.ReadOnly
      ]
  object UpdateSystemTemplate
      extends Effect[
        UpdateSystemTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly
      ]
  object DeleteFlowTemplate
      extends Effect[
        DeleteFlowTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.DeleteFlowTemplateResponse.ReadOnly
      ]
  object SearchSystemInstances
      extends Stream[
        SearchSystemInstancesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
      ]
  object SearchSystemInstancesPaginated
      extends Effect[
        SearchSystemInstancesRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly
      ]
  object UpdateFlowTemplate
      extends Effect[
        UpdateFlowTemplateRequest,
        AwsError,
        zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTThingsGraph] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IoTThingsGraph] { rts =>
        zio.ZIO.succeed {
          new IoTThingsGraph {
            val api: IoTThingsGraphAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IoTThingsGraph = this
            def getSystemInstance(request: GetSystemInstanceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly
            ] = proxy(GetSystemInstance, request)
            def deprecateSystemTemplate(
                request: DeprecateSystemTemplateRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeprecateSystemTemplateResponse.ReadOnly
            ] = proxy(DeprecateSystemTemplate, request)
            def getEntities(request: GetEntitiesRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly
            ] = proxy(GetEntities, request)
            def dissociateEntityFromThing(
                request: DissociateEntityFromThingRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DissociateEntityFromThingResponse.ReadOnly
            ] = proxy(DissociateEntityFromThing, request)
            def deploySystemInstance(request: DeploySystemInstanceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly
            ] = proxy(DeploySystemInstance, request)
            def getSystemTemplate(request: GetSystemTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly
            ] = proxy(GetSystemTemplate, request)
            def describeNamespace(request: DescribeNamespaceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly
            ] = proxy(DescribeNamespace, request)
            def undeploySystemInstance(
                request: UndeploySystemInstanceRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly
            ] = proxy(UndeploySystemInstance, request)
            def searchFlowTemplates(
                request: SearchFlowTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchFlowTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchFlowTemplatesPaginated(
                request: SearchFlowTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.SearchFlowTemplatesResponse.ReadOnly
            ] = proxy(SearchFlowTemplatesPaginated, request)
            def createSystemInstance(request: CreateSystemInstanceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.CreateSystemInstanceResponse.ReadOnly
            ] = proxy(CreateSystemInstance, request)
            def searchThings(request: SearchThingsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.Thing.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchThings, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchThingsPaginated(request: SearchThingsRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly
            ] = proxy(SearchThingsPaginated, request)
            def associateEntityToThing(
                request: AssociateEntityToThingRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.AssociateEntityToThingResponse.ReadOnly
            ] = proxy(AssociateEntityToThing, request)
            def getFlowTemplate(request: GetFlowTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly
            ] = proxy(GetFlowTemplate, request)
            def deleteSystemInstance(request: DeleteSystemInstanceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeleteSystemInstanceResponse.ReadOnly
            ] = proxy(DeleteSystemInstance, request)
            def searchEntities(request: SearchEntitiesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchEntities, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchEntitiesPaginated(request: SearchEntitiesRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly
            ] = proxy(SearchEntitiesPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createFlowTemplate(request: CreateFlowTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly
            ] = proxy(CreateFlowTemplate, request)
            def deleteSystemTemplate(request: DeleteSystemTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeleteSystemTemplateResponse.ReadOnly
            ] = proxy(DeleteSystemTemplate, request)
            def deprecateFlowTemplate(
                request: DeprecateFlowTemplateRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeprecateFlowTemplateResponse.ReadOnly
            ] = proxy(DeprecateFlowTemplate, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.Tag.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTagsForResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getNamespaceDeletionStatus(
                request: GetNamespaceDeletionStatusRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly
            ] = proxy(GetNamespaceDeletionStatus, request)
            def createSystemTemplate(
                request: CreateSystemTemplateRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateSystemTemplate, request)
            def uploadEntityDefinitions(
                request: UploadEntityDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.UploadEntityDefinitionsResponse.ReadOnly
            ] = proxy(UploadEntityDefinitions, request)
            def searchFlowExecutions(
                request: SearchFlowExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchFlowExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchFlowExecutionsPaginated(
                request: SearchFlowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly
            ] = proxy(SearchFlowExecutionsPaginated, request)
            def listFlowExecutionMessages(
                request: ListFlowExecutionMessagesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFlowExecutionMessages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFlowExecutionMessagesPaginated(
                request: ListFlowExecutionMessagesRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly
            ] = proxy(ListFlowExecutionMessagesPaginated, request)
            def getUploadStatus(request: GetUploadStatusRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly
            ] = proxy(GetUploadStatus, request)
            def getSystemTemplateRevisions(
                request: GetSystemTemplateRevisionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetSystemTemplateRevisions, request)
                }
                .getOrThrowFiberFailure()
            }
            def getSystemTemplateRevisionsPaginated(
                request: GetSystemTemplateRevisionsRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetSystemTemplateRevisionsResponse.ReadOnly
            ] = proxy(GetSystemTemplateRevisionsPaginated, request)
            def getFlowTemplateRevisions(
                request: GetFlowTemplateRevisionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetFlowTemplateRevisions, request)
                }
                .getOrThrowFiberFailure()
            }
            def getFlowTemplateRevisionsPaginated(
                request: GetFlowTemplateRevisionsRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly
            ] = proxy(GetFlowTemplateRevisionsPaginated, request)
            def deleteNamespace(request: DeleteNamespaceRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly
            ] = proxy(DeleteNamespace, request)
            def searchSystemTemplates(
                request: SearchSystemTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchSystemTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchSystemTemplatesPaginated(
                request: SearchSystemTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.SearchSystemTemplatesResponse.ReadOnly
            ] = proxy(SearchSystemTemplatesPaginated, request)
            def updateSystemTemplate(request: UpdateSystemTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly
            ] = proxy(UpdateSystemTemplate, request)
            def deleteFlowTemplate(request: DeleteFlowTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.DeleteFlowTemplateResponse.ReadOnly
            ] = proxy(DeleteFlowTemplate, request)
            def searchSystemInstances(
                request: SearchSystemInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchSystemInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchSystemInstancesPaginated(
                request: SearchSystemInstancesRequest
            ): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly
            ] = proxy(SearchSystemInstancesPaginated, request)
            def updateFlowTemplate(request: UpdateFlowTemplateRequest): IO[
              AwsError,
              zio.aws.iotthingsgraph.model.UpdateFlowTemplateResponse.ReadOnly
            ] = proxy(UpdateFlowTemplate, request)
          }
        }
      }
    }
  }
}
