package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters._
sealed trait EntityFilterName {
  def unwrap
      : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName
}
object EntityFilterName {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName
  ): zio.aws.iotthingsgraph.model.EntityFilterName = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.NAMESPACE =>
      val r = NAMESPACE
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.SEMANTIC_TYPE_PATH =>
      val r = SEMANTIC_TYPE_PATH
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.REFERENCED_ENTITY_ID =>
      val r = REFERENCED_ENTITY_ID
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.EntityFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object NAME extends zio.aws.iotthingsgraph.model.EntityFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.NAME
  }
  case object NAMESPACE extends zio.aws.iotthingsgraph.model.EntityFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.NAMESPACE
  }
  case object SEMANTIC_TYPE_PATH
      extends zio.aws.iotthingsgraph.model.EntityFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.SEMANTIC_TYPE_PATH
  }
  case object REFERENCED_ENTITY_ID
      extends zio.aws.iotthingsgraph.model.EntityFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName.REFERENCED_ENTITY_ID
  }
}
