package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSystemTemplateResponse(
    description: Optional[
      zio.aws.iotthingsgraph.model.SystemTemplateDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse = {
    import GetSystemTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
      .builder()
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.wrap(buildAwsValue())
}
object GetSystemTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetSystemTemplateResponse =
      zio.aws.iotthingsgraph.model
        .GetSystemTemplateResponse(description.map(value => value.asEditable))
    def description: Optional[
      zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly
    ]
    def getDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly
    ] = AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
  ) extends zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly {
    override val description: Optional[
      zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemTemplateDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
  ): zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
