package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEntitiesResponse(
    descriptions: Optional[
      Iterable[zio.aws.iotthingsgraph.model.EntityDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse = {
    import GetEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse
      .builder()
      .optionallyWith(
        descriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.descriptions)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetEntitiesResponse.wrap(buildAwsValue())
}
object GetEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetEntitiesResponse =
      zio.aws.iotthingsgraph.model.GetEntitiesResponse(
        descriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def descriptions: Optional[
      List[zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly]
    ]
    def getDescriptions: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("descriptions", descriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse
  ) extends zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly {
    override val descriptions: Optional[
      List[zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.descriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.EntityDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse
  ): zio.aws.iotthingsgraph.model.GetEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
