package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchEntitiesResponse(
    descriptions: Optional[
      Iterable[zio.aws.iotthingsgraph.model.EntityDescription]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse = {
    import SearchEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse
      .builder()
      .optionallyWith(
        descriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.descriptions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchEntitiesResponse.wrap(buildAwsValue())
}
object SearchEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchEntitiesResponse =
      zio.aws.iotthingsgraph.model.SearchEntitiesResponse(
        descriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def descriptions: Optional[
      List[zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getDescriptions: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("descriptions", descriptions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse
  ) extends zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly {
    override val descriptions: Optional[
      List[zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.descriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.EntityDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse
  ): zio.aws.iotthingsgraph.model.SearchEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
