package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DependencyRevision(
    id: Optional[Urn] = Optional.Absent,
    revisionNumber: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevision = {
    import DependencyRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevision
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        revisionNumber.map(value => Version.unwrap(value): java.lang.Long)
      )(_.revisionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.DependencyRevision.ReadOnly =
    zio.aws.iotthingsgraph.model.DependencyRevision.wrap(buildAwsValue())
}
object DependencyRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DependencyRevision =
      zio.aws.iotthingsgraph.model.DependencyRevision(
        id.map(value => value),
        revisionNumber.map(value => value)
      )
    def id: Optional[Urn]
    def revisionNumber: Optional[Version]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getRevisionNumber: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("revisionNumber", revisionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevision
  ) extends zio.aws.iotthingsgraph.model.DependencyRevision.ReadOnly {
    override val id: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val revisionNumber: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionNumber())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevision
  ): zio.aws.iotthingsgraph.model.DependencyRevision.ReadOnly = new Wrapper(
    impl
  )
}
