package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFlowExecutionMessagesResponse(
    messages: Optional[
      Iterable[zio.aws.iotthingsgraph.model.FlowExecutionMessage]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse = {
    import ListFlowExecutionMessagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
      .builder()
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse
      .wrap(buildAwsValue())
}
object ListFlowExecutionMessagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse =
      zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse(
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def messages: Optional[
      List[zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
  ) extends zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly {
    override val messages: Optional[
      List[zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.FlowExecutionMessage.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
  ): zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesResponse.ReadOnly =
    new Wrapper(impl)
}
