package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, NamespaceName, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNamespaceResponse(
    namespaceArn: Optional[Arn] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent,
    trackingNamespaceName: Optional[NamespaceName] = Optional.Absent,
    trackingNamespaceVersion: Optional[Version] = Optional.Absent,
    namespaceVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse = {
    import DescribeNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
      .builder()
      .optionallyWith(
        namespaceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.namespaceArn)
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(
        trackingNamespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.trackingNamespaceName)
      .optionallyWith(
        trackingNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.trackingNamespaceVersion)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.wrap(buildAwsValue())
}
object DescribeNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DescribeNamespaceResponse =
      zio.aws.iotthingsgraph.model.DescribeNamespaceResponse(
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        trackingNamespaceName.map(value => value),
        trackingNamespaceVersion.map(value => value),
        namespaceVersion.map(value => value)
      )
    def namespaceArn: Optional[Arn]
    def namespaceName: Optional[NamespaceName]
    def trackingNamespaceName: Optional[NamespaceName]
    def trackingNamespaceVersion: Optional[Version]
    def namespaceVersion: Optional[Version]
    def getNamespaceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getTrackingNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("trackingNamespaceName", trackingNamespaceName)
    def getTrackingNamespaceVersion: ZIO[Any, AwsError, Version] = AwsError
      .unwrapOptionField("trackingNamespaceVersion", trackingNamespaceVersion)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
  ) extends zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly {
    override val namespaceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
    override val trackingNamespaceName: Optional[NamespaceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trackingNamespaceName())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
        )
    override val trackingNamespaceVersion: Optional[Version] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trackingNamespaceVersion())
        .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
    override val namespaceVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse
  ): zio.aws.iotthingsgraph.model.DescribeNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
