package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{NamespaceName, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetNamespaceDeletionStatusResponse(
    namespaceArn: Optional[Arn] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent,
    status: Optional[zio.aws.iotthingsgraph.model.NamespaceDeletionStatus] =
      Optional.Absent,
    errorCode: Optional[
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse = {
    import GetNamespaceDeletionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
      .builder()
      .optionallyWith(
        namespaceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.namespaceArn)
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
      .wrap(buildAwsValue())
}
object GetNamespaceDeletionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse =
      zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse(
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        status.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def namespaceArn: Optional[Arn]
    def namespaceName: Optional[NamespaceName]
    def status: Optional[zio.aws.iotthingsgraph.model.NamespaceDeletionStatus]
    def errorCode: Optional[
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ]
    def errorMessage: Optional[String]
    def getNamespaceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
  ) extends zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly {
    override val namespaceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
    override val status
        : Optional[zio.aws.iotthingsgraph.model.NamespaceDeletionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotthingsgraph.model.NamespaceDeletionStatus.wrap(value)
        )
    override val errorCode: Optional[
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value =>
        zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
          .wrap(value)
      )
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
  ): zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
