package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{RoleArn, Version, S3BucketName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SystemInstanceDescription(
    summary: Optional[zio.aws.iotthingsgraph.model.SystemInstanceSummary] =
      Optional.Absent,
    definition: Optional[zio.aws.iotthingsgraph.model.DefinitionDocument] =
      Optional.Absent,
    s3BucketName: Optional[S3BucketName] = Optional.Absent,
    metricsConfiguration: Optional[
      zio.aws.iotthingsgraph.model.MetricsConfiguration
    ] = Optional.Absent,
    validatedNamespaceVersion: Optional[Version] = Optional.Absent,
    validatedDependencyRevisions: Optional[
      Iterable[zio.aws.iotthingsgraph.model.DependencyRevision]
    ] = Optional.Absent,
    flowActionsRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDescription = {
    import SystemInstanceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDescription
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(metricsConfiguration.map(value => value.buildAwsValue()))(
        _.metricsConfiguration
      )
      .optionallyWith(
        validatedNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.validatedNamespaceVersion)
      .optionallyWith(
        validatedDependencyRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validatedDependencyRevisions)
      .optionallyWith(
        flowActionsRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.flowActionsRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemInstanceDescription.wrap(buildAwsValue())
}
object SystemInstanceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemInstanceDescription =
      zio.aws.iotthingsgraph.model.SystemInstanceDescription(
        summary.map(value => value.asEditable),
        definition.map(value => value.asEditable),
        s3BucketName.map(value => value),
        metricsConfiguration.map(value => value.asEditable),
        validatedNamespaceVersion.map(value => value),
        validatedDependencyRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        flowActionsRoleArn.map(value => value)
      )
    def summary
        : Optional[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly]
    def definition
        : Optional[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly]
    def s3BucketName: Optional[S3BucketName]
    def metricsConfiguration
        : Optional[zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly]
    def validatedNamespaceVersion: Optional[Version]
    def validatedDependencyRevisions: Optional[
      List[zio.aws.iotthingsgraph.model.DependencyRevision.ReadOnly]
    ]
    def flowActionsRoleArn: Optional[RoleArn]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getMetricsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("metricsConfiguration", metricsConfiguration)
    def getValidatedNamespaceVersion: ZIO[Any, AwsError, Version] = AwsError
      .unwrapOptionField("validatedNamespaceVersion", validatedNamespaceVersion)
    def getValidatedDependencyRevisions: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.DependencyRevision.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validatedDependencyRevisions",
      validatedDependencyRevisions
    )
    def getFlowActionsRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("flowActionsRoleArn", flowActionsRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDescription
  ) extends zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly {
    override val summary: Optional[
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(value)
      )
    override val definition
        : Optional[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value =>
          zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(value)
        )
    override val s3BucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.iotthingsgraph.model.primitives.S3BucketName(value))
    override val metricsConfiguration
        : Optional[zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsConfiguration())
        .map(value =>
          zio.aws.iotthingsgraph.model.MetricsConfiguration.wrap(value)
        )
    override val validatedNamespaceVersion: Optional[Version] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validatedNamespaceVersion())
        .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
    override val validatedDependencyRevisions: Optional[
      List[zio.aws.iotthingsgraph.model.DependencyRevision.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validatedDependencyRevisions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.DependencyRevision.wrap(item)
        }.toList
      )
    override val flowActionsRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.flowActionsRoleArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDescription
  ): zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly =
    new Wrapper(impl)
}
