package zio.aws.iotthingsgraph.model
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{
  Version,
  MaxResults,
  NextToken,
  Urn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchThingsRequest(
    entityId: Urn,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    namespaceVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest = {
    import SearchThingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
      .builder()
      .entityId(Urn.unwrap(entityId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SearchThingsRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchThingsRequest.wrap(buildAwsValue())
}
object SearchThingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchThingsRequest =
      zio.aws.iotthingsgraph.model.SearchThingsRequest(
        entityId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        namespaceVersion.map(value => value)
      )
    def entityId: Urn
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def namespaceVersion: Optional[Version]
    def getEntityId: ZIO[Any, Nothing, Urn] = ZIO.succeed(entityId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
  ) extends zio.aws.iotthingsgraph.model.SearchThingsRequest.ReadOnly {
    override val entityId: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.entityId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
    override val namespaceVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
  ): zio.aws.iotthingsgraph.model.SearchThingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
