package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFlowTemplateRequest(
    id: Urn,
    revisionNumber: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest = {
    import GetFlowTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .optionallyWith(
        revisionNumber.map(value => Version.unwrap(value): java.lang.Long)
      )(_.revisionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.GetFlowTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetFlowTemplateRequest.wrap(buildAwsValue())
}
object GetFlowTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetFlowTemplateRequest =
      zio.aws.iotthingsgraph.model
        .GetFlowTemplateRequest(id, revisionNumber.map(value => value))
    def id: Urn
    def revisionNumber: Optional[Version]
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
    def getRevisionNumber: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("revisionNumber", revisionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.GetFlowTemplateRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
    override val revisionNumber: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionNumber())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest
  ): zio.aws.iotthingsgraph.model.GetFlowTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
