package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  RoleArn,
  S3BucketName,
  GroupName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSystemInstanceRequest(
    tags: Optional[Iterable[zio.aws.iotthingsgraph.model.Tag]] =
      Optional.Absent,
    definition: zio.aws.iotthingsgraph.model.DefinitionDocument,
    target: zio.aws.iotthingsgraph.model.DeploymentTarget,
    greengrassGroupName: Optional[GroupName] = Optional.Absent,
    s3BucketName: Optional[S3BucketName] = Optional.Absent,
    metricsConfiguration: Optional[
      zio.aws.iotthingsgraph.model.MetricsConfiguration
    ] = Optional.Absent,
    flowActionsRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest = {
    import CreateSystemInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .definition(definition.buildAwsValue())
      .target(target.unwrap)
      .optionallyWith(
        greengrassGroupName.map(value =>
          GroupName.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupName)
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(metricsConfiguration.map(value => value.buildAwsValue()))(
        _.metricsConfiguration
      )
      .optionallyWith(
        flowActionsRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.flowActionsRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.CreateSystemInstanceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.CreateSystemInstanceRequest
      .wrap(buildAwsValue())
}
object CreateSystemInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.CreateSystemInstanceRequest =
      zio.aws.iotthingsgraph.model.CreateSystemInstanceRequest(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        definition.asEditable,
        target,
        greengrassGroupName.map(value => value),
        s3BucketName.map(value => value),
        metricsConfiguration.map(value => value.asEditable),
        flowActionsRoleArn.map(value => value)
      )
    def tags: Optional[List[zio.aws.iotthingsgraph.model.Tag.ReadOnly]]
    def definition: zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    def target: zio.aws.iotthingsgraph.model.DeploymentTarget
    def greengrassGroupName: Optional[GroupName]
    def s3BucketName: Optional[S3BucketName]
    def metricsConfiguration
        : Optional[zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly]
    def flowActionsRoleArn: Optional[RoleArn]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotthingsgraph.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = ZIO.succeed(definition)
    def getTarget
        : ZIO[Any, Nothing, zio.aws.iotthingsgraph.model.DeploymentTarget] =
      ZIO.succeed(target)
    def getGreengrassGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("greengrassGroupName", greengrassGroupName)
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getMetricsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("metricsConfiguration", metricsConfiguration)
    def getFlowActionsRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("flowActionsRoleArn", flowActionsRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest
  ) extends zio.aws.iotthingsgraph.model.CreateSystemInstanceRequest.ReadOnly {
    override val tags
        : Optional[List[zio.aws.iotthingsgraph.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotthingsgraph.model.Tag.wrap(item)
          }.toList
        )
    override val definition
        : zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly =
      zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(impl.definition())
    override val target: zio.aws.iotthingsgraph.model.DeploymentTarget =
      zio.aws.iotthingsgraph.model.DeploymentTarget.wrap(impl.target())
    override val greengrassGroupName: Optional[GroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrassGroupName())
        .map(value => zio.aws.iotthingsgraph.model.primitives.GroupName(value))
    override val s3BucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.iotthingsgraph.model.primitives.S3BucketName(value))
    override val metricsConfiguration
        : Optional[zio.aws.iotthingsgraph.model.MetricsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsConfiguration())
        .map(value =>
          zio.aws.iotthingsgraph.model.MetricsConfiguration.wrap(value)
        )
    override val flowActionsRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.flowActionsRoleArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest
  ): zio.aws.iotthingsgraph.model.CreateSystemInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
