package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.Urn
import scala.jdk.CollectionConverters._
final case class DeleteFlowTemplateRequest(id: Urn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest = {
    import DeleteFlowTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DeleteFlowTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.DeleteFlowTemplateRequest.wrap(buildAwsValue())
}
object DeleteFlowTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DeleteFlowTemplateRequest =
      zio.aws.iotthingsgraph.model.DeleteFlowTemplateRequest(id)
    def id: Urn
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.DeleteFlowTemplateRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest
  ): zio.aws.iotthingsgraph.model.DeleteFlowTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
