package zio.aws.iotthingsgraph.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class SearchSystemInstancesRequest(
    filters: Option[
      Iterable[zio.aws.iotthingsgraph.model.SystemInstanceFilter]
    ] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest = {
    import SearchSystemInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.SearchSystemInstancesRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchSystemInstancesRequest
      .wrap(buildAwsValue())
}
object SearchSystemInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchSystemInstancesRequest =
      zio.aws.iotthingsgraph.model.SearchSystemInstancesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[
      List[zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest
  ) extends zio.aws.iotthingsgraph.model.SearchSystemInstancesRequest.ReadOnly {
    override val filters: Option[
      List[zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.SystemInstanceFilter.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest
  ): zio.aws.iotthingsgraph.model.SearchSystemInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
