package zio.aws.iotthingsgraph.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  MaxResults,
  NextToken,
  FlowExecutionId
}
import scala.jdk.CollectionConverters._
final case class ListFlowExecutionMessagesRequest(
    flowExecutionId: FlowExecutionId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest = {
    import ListFlowExecutionMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
      .builder()
      .flowExecutionId(
        FlowExecutionId.unwrap(flowExecutionId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest
      .wrap(buildAwsValue())
}
object ListFlowExecutionMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest =
      zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest(
        flowExecutionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def flowExecutionId: FlowExecutionId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFlowExecutionId: ZIO[Any, Nothing, FlowExecutionId] =
      ZIO.succeed(flowExecutionId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
  ) extends zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest.ReadOnly {
    override val flowExecutionId: FlowExecutionId =
      zio.aws.iotthingsgraph.model.primitives
        .FlowExecutionId(impl.flowExecutionId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
  ): zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest.ReadOnly =
    new Wrapper(impl)
}
