package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn}
import scala.jdk.CollectionConverters._
final case class UpdateSystemTemplateRequest(
    id: Urn,
    definition: zio.aws.iotthingsgraph.model.DefinitionDocument,
    compatibleNamespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest = {
    import UpdateSystemTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .definition(definition.buildAwsValue())
      .optionallyWith(
        compatibleNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.compatibleNamespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UpdateSystemTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.UpdateSystemTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateSystemTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.UpdateSystemTemplateRequest =
      zio.aws.iotthingsgraph.model.UpdateSystemTemplateRequest(
        id,
        definition.asEditable,
        compatibleNamespaceVersion.map(value => value)
      )
    def id: Urn
    def definition: zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    def compatibleNamespaceVersion: Option[Version]
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = ZIO.succeed(definition)
    def getCompatibleNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField(
        "compatibleNamespaceVersion",
        compatibleNamespaceVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.UpdateSystemTemplateRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
    override val definition
        : zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly =
      zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(impl.definition())
    override val compatibleNamespaceVersion: Option[Version] = scala
      .Option(impl.compatibleNamespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest
  ): zio.aws.iotthingsgraph.model.UpdateSystemTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
