package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Timestamp, Urn, FlowExecutionId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FlowExecutionSummary(
    flowExecutionId: Option[FlowExecutionId] = None,
    status: Option[zio.aws.iotthingsgraph.model.FlowExecutionStatus] = None,
    systemInstanceId: Option[Urn] = None,
    flowTemplateId: Option[Urn] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary = {
    import FlowExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary
      .builder()
      .optionallyWith(
        flowExecutionId.map(value =>
          FlowExecutionId.unwrap(value): java.lang.String
        )
      )(_.flowExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        systemInstanceId.map(value => Urn.unwrap(value): java.lang.String)
      )(_.systemInstanceId)
      .optionallyWith(
        flowTemplateId.map(value => Urn.unwrap(value): java.lang.String)
      )(_.flowTemplateId)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly =
    zio.aws.iotthingsgraph.model.FlowExecutionSummary.wrap(buildAwsValue())
}
object FlowExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.FlowExecutionSummary =
      zio.aws.iotthingsgraph.model.FlowExecutionSummary(
        flowExecutionId.map(value => value),
        status.map(value => value),
        systemInstanceId.map(value => value),
        flowTemplateId.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def flowExecutionId: Option[FlowExecutionId]
    def status: Option[zio.aws.iotthingsgraph.model.FlowExecutionStatus]
    def systemInstanceId: Option[Urn]
    def flowTemplateId: Option[Urn]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def getFlowExecutionId: ZIO[Any, AwsError, FlowExecutionId] =
      AwsError.unwrapOptionField("flowExecutionId", flowExecutionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotthingsgraph.model.FlowExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSystemInstanceId: ZIO[Any, AwsError, Urn] =
      AwsError.unwrapOptionField("systemInstanceId", systemInstanceId)
    def getFlowTemplateId: ZIO[Any, AwsError, Urn] =
      AwsError.unwrapOptionField("flowTemplateId", flowTemplateId)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary
  ) extends zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly {
    override val flowExecutionId: Option[FlowExecutionId] = scala
      .Option(impl.flowExecutionId())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.FlowExecutionId(value)
      )
    override val status
        : Option[zio.aws.iotthingsgraph.model.FlowExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.iotthingsgraph.model.FlowExecutionStatus.wrap(value)
      )
    override val systemInstanceId: Option[Urn] = scala
      .Option(impl.systemInstanceId())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val flowTemplateId: Option[Urn] = scala
      .Option(impl.flowTemplateId())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary
  ): zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
