package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class SearchSystemInstancesResponse(
    summaries: Option[
      Iterable[zio.aws.iotthingsgraph.model.SystemInstanceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse = {
    import SearchSystemInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse
      .wrap(buildAwsValue())
}
object SearchSystemInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse =
      zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Option[
      List[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse
  ) extends zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly {
    override val summaries: Option[
      List[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly]
    ] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse
  ): zio.aws.iotthingsgraph.model.SearchSystemInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
