package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.Urn
import scala.jdk.CollectionConverters._
final case class GetSystemInstanceRequest(id: Urn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest = {
    import GetSystemInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemInstanceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemInstanceRequest.wrap(buildAwsValue())
}
object GetSystemInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetSystemInstanceRequest =
      zio.aws.iotthingsgraph.model.GetSystemInstanceRequest(id)
    def id: Urn
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest
  ) extends zio.aws.iotthingsgraph.model.GetSystemInstanceRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest
  ): zio.aws.iotthingsgraph.model.GetSystemInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
