package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Version
import scala.jdk.CollectionConverters._
final case class FlowTemplateDescription(
    summary: Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary] = None,
    definition: Option[zio.aws.iotthingsgraph.model.DefinitionDocument] = None,
    validatedNamespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateDescription = {
    import FlowTemplateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateDescription
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(
        validatedNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.validatedNamespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.FlowTemplateDescription.ReadOnly =
    zio.aws.iotthingsgraph.model.FlowTemplateDescription.wrap(buildAwsValue())
}
object FlowTemplateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.FlowTemplateDescription =
      zio.aws.iotthingsgraph.model.FlowTemplateDescription(
        summary.map(value => value.asEditable),
        definition.map(value => value.asEditable),
        validatedNamespaceVersion.map(value => value)
      )
    def summary
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly]
    def definition
        : Option[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly]
    def validatedNamespaceVersion: Option[Version]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
    def getValidatedNamespaceVersion: ZIO[Any, AwsError, Version] = AwsError
      .unwrapOptionField("validatedNamespaceVersion", validatedNamespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateDescription
  ) extends zio.aws.iotthingsgraph.model.FlowTemplateDescription.ReadOnly {
    override val summary
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly] =
      scala
        .Option(impl.summary())
        .map(value =>
          zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(value)
        )
    override val definition
        : Option[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly] =
      scala
        .Option(impl.definition())
        .map(value =>
          zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(value)
        )
    override val validatedNamespaceVersion: Option[Version] = scala
      .Option(impl.validatedNamespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateDescription
  ): zio.aws.iotthingsgraph.model.FlowTemplateDescription.ReadOnly =
    new Wrapper(impl)
}
