package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.DefinitionText
import scala.jdk.CollectionConverters._
final case class DefinitionDocument(
    language: zio.aws.iotthingsgraph.model.DefinitionLanguage,
    text: DefinitionText
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument = {
    import DefinitionDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument
      .builder()
      .language(language.unwrap)
      .text(DefinitionText.unwrap(text): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly =
    zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(buildAwsValue())
}
object DefinitionDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DefinitionDocument =
      zio.aws.iotthingsgraph.model.DefinitionDocument(language, text)
    def language: zio.aws.iotthingsgraph.model.DefinitionLanguage
    def text: DefinitionText
    def getLanguage
        : ZIO[Any, Nothing, zio.aws.iotthingsgraph.model.DefinitionLanguage] =
      ZIO.succeed(language)
    def getText: ZIO[Any, Nothing, DefinitionText] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument
  ) extends zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly {
    override val language: zio.aws.iotthingsgraph.model.DefinitionLanguage =
      zio.aws.iotthingsgraph.model.DefinitionLanguage.wrap(impl.language())
    override val text: DefinitionText =
      zio.aws.iotthingsgraph.model.primitives.DefinitionText(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument
  ): zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly = new Wrapper(
    impl
  )
}
