package zio.aws.iotthingsgraph.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  Version,
  MaxResults,
  NextToken,
  Urn
}
import scala.jdk.CollectionConverters._
final case class SearchThingsRequest(
    entityId: Urn,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    namespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest = {
    import SearchThingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
      .builder()
      .entityId(Urn.unwrap(entityId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SearchThingsRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchThingsRequest.wrap(buildAwsValue())
}
object SearchThingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchThingsRequest =
      zio.aws.iotthingsgraph.model.SearchThingsRequest(
        entityId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        namespaceVersion.map(value => value)
      )
    def entityId: Urn
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def namespaceVersion: Option[Version]
    def getEntityId: ZIO[Any, Nothing, Urn] = ZIO.succeed(entityId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
  ) extends zio.aws.iotthingsgraph.model.SearchThingsRequest.ReadOnly {
    override val entityId: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.entityId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
    override val namespaceVersion: Option[Version] = scala
      .Option(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest
  ): zio.aws.iotthingsgraph.model.SearchThingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
