package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters._
sealed trait SystemInstanceFilterName {
  def unwrap: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName
}
object SystemInstanceFilterName {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName
  ): zio.aws.iotthingsgraph.model.SystemInstanceFilterName = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.SYSTEM_TEMPLATE_ID =>
      val r = SYSTEM_TEMPLATE_ID
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.STATUS =>
      val r = STATUS
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.GREENGRASS_GROUP_NAME =>
      val r = GREENGRASS_GROUP_NAME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.SystemInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object SYSTEM_TEMPLATE_ID
      extends zio.aws.iotthingsgraph.model.SystemInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.SYSTEM_TEMPLATE_ID
  }
  case object STATUS
      extends zio.aws.iotthingsgraph.model.SystemInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.STATUS
  }
  case object GREENGRASS_GROUP_NAME
      extends zio.aws.iotthingsgraph.model.SystemInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName =
      software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilterName.GREENGRASS_GROUP_NAME
  }
}
