package zio.aws.iotthingsgraph.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class SearchEntitiesRequest(
    entityTypes: Iterable[zio.aws.iotthingsgraph.model.EntityType],
    filters: Option[Iterable[zio.aws.iotthingsgraph.model.EntityFilter]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    namespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest = {
    import SearchEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
      .builder()
      .entityTypesWithStrings(entityTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SearchEntitiesRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchEntitiesRequest.wrap(buildAwsValue())
}
object SearchEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchEntitiesRequest =
      zio.aws.iotthingsgraph.model.SearchEntitiesRequest(
        entityTypes,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value),
        namespaceVersion.map(value => value)
      )
    def entityTypes: List[zio.aws.iotthingsgraph.model.EntityType]
    def filters
        : Option[List[zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def namespaceVersion: Option[Version]
    def getEntityTypes
        : ZIO[Any, Nothing, List[zio.aws.iotthingsgraph.model.EntityType]] =
      ZIO.succeed(entityTypes)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
  ) extends zio.aws.iotthingsgraph.model.SearchEntitiesRequest.ReadOnly {
    override val entityTypes: List[zio.aws.iotthingsgraph.model.EntityType] =
      impl
        .entityTypes()
        .asScala
        .map { item =>
          zio.aws.iotthingsgraph.model.EntityType.wrap(item)
        }
        .toList
    override val filters
        : Option[List[zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotthingsgraph.model.EntityFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
    override val namespaceVersion: Option[Version] = scala
      .Option(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
  ): zio.aws.iotthingsgraph.model.SearchEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
