package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class SearchFlowExecutionsResponse(
    summaries: Option[
      Iterable[zio.aws.iotthingsgraph.model.FlowExecutionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse = {
    import SearchFlowExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse
      .wrap(buildAwsValue())
}
object SearchFlowExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse =
      zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Option[
      List[zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse
  ) extends zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly {
    override val summaries: Option[
      List[zio.aws.iotthingsgraph.model.FlowExecutionSummary.ReadOnly]
    ] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.FlowExecutionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse
  ): zio.aws.iotthingsgraph.model.SearchFlowExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
