package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  FlowExecutionMessagePayload,
  Timestamp,
  FlowExecutionMessageId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FlowExecutionMessage(
    messageId: Option[FlowExecutionMessageId] = None,
    eventType: Option[zio.aws.iotthingsgraph.model.FlowExecutionEventType] =
      None,
    timestamp: Option[Timestamp] = None,
    payload: Option[FlowExecutionMessagePayload] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage = {
    import FlowExecutionMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage
      .builder()
      .optionallyWith(
        messageId.map(value =>
          FlowExecutionMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        payload.map(value =>
          FlowExecutionMessagePayload.unwrap(value): java.lang.String
        )
      )(_.payload)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly =
    zio.aws.iotthingsgraph.model.FlowExecutionMessage.wrap(buildAwsValue())
}
object FlowExecutionMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.FlowExecutionMessage =
      zio.aws.iotthingsgraph.model.FlowExecutionMessage(
        messageId.map(value => value),
        eventType.map(value => value),
        timestamp.map(value => value),
        payload.map(value => value)
      )
    def messageId: Option[FlowExecutionMessageId]
    def eventType: Option[zio.aws.iotthingsgraph.model.FlowExecutionEventType]
    def timestamp: Option[Timestamp]
    def payload: Option[FlowExecutionMessagePayload]
    def getMessageId: ZIO[Any, AwsError, FlowExecutionMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getEventType: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowExecutionEventType
    ] = AwsError.unwrapOptionField("eventType", eventType)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getPayload: ZIO[Any, AwsError, FlowExecutionMessagePayload] =
      AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage
  ) extends zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly {
    override val messageId: Option[FlowExecutionMessageId] = scala
      .Option(impl.messageId())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.FlowExecutionMessageId(value)
      )
    override val eventType
        : Option[zio.aws.iotthingsgraph.model.FlowExecutionEventType] = scala
      .Option(impl.eventType())
      .map(value =>
        zio.aws.iotthingsgraph.model.FlowExecutionEventType.wrap(value)
      )
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val payload: Option[FlowExecutionMessagePayload] = scala
      .Option(impl.payload())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives
          .FlowExecutionMessagePayload(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage
  ): zio.aws.iotthingsgraph.model.FlowExecutionMessage.ReadOnly = new Wrapper(
    impl
  )
}
