package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Urn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSystemInstanceRequest(
    id: Optional[Urn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest = {
    import DeleteSystemInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DeleteSystemInstanceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.DeleteSystemInstanceRequest
      .wrap(buildAwsValue())
}
object DeleteSystemInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DeleteSystemInstanceRequest =
      zio.aws.iotthingsgraph.model
        .DeleteSystemInstanceRequest(id.map(value => value))
    def id: Optional[Urn]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest
  ) extends zio.aws.iotthingsgraph.model.DeleteSystemInstanceRequest.ReadOnly {
    override val id: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest
  ): zio.aws.iotthingsgraph.model.DeleteSystemInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
