package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentTarget {
  def unwrap
      : software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget
}
object DeploymentTarget {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget
  ): zio.aws.iotthingsgraph.model.DeploymentTarget = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget.GREENGRASS =>
      val r = GREENGRASS
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget.CLOUD =>
      val r = CLOUD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.DeploymentTarget {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget =
      software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget.UNKNOWN_TO_SDK_VERSION
  }
  case object GREENGRASS extends zio.aws.iotthingsgraph.model.DeploymentTarget {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget =
      software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget.GREENGRASS
  }
  case object CLOUD extends zio.aws.iotthingsgraph.model.DeploymentTarget {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget =
      software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget.CLOUD
  }
}
