package zio.aws.iotthingsgraph.model
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{
  MaxResults,
  NextToken,
  FlowExecutionId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFlowExecutionMessagesRequest(
    flowExecutionId: FlowExecutionId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest = {
    import ListFlowExecutionMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
      .builder()
      .flowExecutionId(
        FlowExecutionId.unwrap(flowExecutionId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest
      .wrap(buildAwsValue())
}
object ListFlowExecutionMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest =
      zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest(
        flowExecutionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def flowExecutionId: FlowExecutionId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFlowExecutionId: ZIO[Any, Nothing, FlowExecutionId] =
      ZIO.succeed(flowExecutionId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
  ) extends zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest.ReadOnly {
    override val flowExecutionId: FlowExecutionId =
      zio.aws.iotthingsgraph.model.primitives
        .FlowExecutionId(impl.flowExecutionId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
  ): zio.aws.iotthingsgraph.model.ListFlowExecutionMessagesRequest.ReadOnly =
    new Wrapper(impl)
}
