package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UndeploySystemInstanceResponse(
    summary: Option[zio.aws.iotthingsgraph.model.SystemInstanceSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse = {
    import UndeploySystemInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse
      .wrap(buildAwsValue())
}
object UndeploySystemInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse =
      zio.aws.iotthingsgraph.model
        .UndeploySystemInstanceResponse(summary.map(value => value.asEditable))
    def summary
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse
  ) extends zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly {
    override val summary
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly] =
      scala
        .Option(impl.summary())
        .map(value =>
          zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse
  ): zio.aws.iotthingsgraph.model.UndeploySystemInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
