package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{NamespaceName, Arn}
import scala.jdk.CollectionConverters._
final case class GetNamespaceDeletionStatusResponse(
    namespaceArn: Option[Arn] = None,
    namespaceName: Option[NamespaceName] = None,
    status: Option[zio.aws.iotthingsgraph.model.NamespaceDeletionStatus] = None,
    errorCode: Option[
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse = {
    import GetNamespaceDeletionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
      .builder()
      .optionallyWith(
        namespaceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.namespaceArn)
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
      .wrap(buildAwsValue())
}
object GetNamespaceDeletionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse =
      zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse(
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        status.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def namespaceArn: Option[Arn]
    def namespaceName: Option[NamespaceName]
    def status: Option[zio.aws.iotthingsgraph.model.NamespaceDeletionStatus]
    def errorCode
        : Option[zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes]
    def errorMessage: Option[String]
    def getNamespaceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
  ) extends zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly {
    override val namespaceArn: Option[Arn] = scala
      .Option(impl.namespaceArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val namespaceName: Option[NamespaceName] = scala
      .Option(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
    override val status
        : Option[zio.aws.iotthingsgraph.model.NamespaceDeletionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.iotthingsgraph.model.NamespaceDeletionStatus.wrap(value)
      )
    override val errorCode: Option[
      zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
    ] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
          .wrap(value)
      )
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
  ): zio.aws.iotthingsgraph.model.GetNamespaceDeletionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
