package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters._
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.iotthingsgraph.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.EntityType
  ): zio.aws.iotthingsgraph.model.EntityType = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.DEVICE =>
      val r = DEVICE
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.SERVICE =>
      val r = SERVICE
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.DEVICE_MODEL =>
      val r = DEVICE_MODEL
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.CAPABILITY =>
      val r = CAPABILITY
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.STATE =>
      val r = STATE
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.ACTION =>
      val r = ACTION
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.EVENT =>
      val r = EVENT
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.PROPERTY =>
      val r = PROPERTY
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.MAPPING =>
      val r = MAPPING
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.EntityType.ENUM =>
      val r = ENUM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEVICE extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.DEVICE
  }
  case object SERVICE extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.SERVICE
  }
  case object DEVICE_MODEL extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.DEVICE_MODEL
  }
  case object CAPABILITY extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.CAPABILITY
  }
  case object STATE extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.STATE
  }
  case object ACTION extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.ACTION
  }
  case object EVENT extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.EVENT
  }
  case object PROPERTY extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.PROPERTY
  }
  case object MAPPING extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.MAPPING
  }
  case object ENUM extends zio.aws.iotthingsgraph.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.EntityType =
      software.amazon.awssdk.services.iotthingsgraph.model.EntityType.ENUM
  }
}
