package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFlowTemplateResponse(
    summary: Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse = {
    import CreateFlowTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse
      .wrap(buildAwsValue())
}
object CreateFlowTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse =
      zio.aws.iotthingsgraph.model
        .CreateFlowTemplateResponse(summary.map(value => value.asEditable))
    def summary
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse
  ) extends zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly {
    override val summary
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly] =
      scala
        .Option(impl.summary())
        .map(value =>
          zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse
  ): zio.aws.iotthingsgraph.model.CreateFlowTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
